/*
 * Decompiled with CFR 0.152.
 */
package com.android.gps.data;

import com.Application;
import com.android.core.data.api.AndroidController;
import com.android.core.domain.AndroidService;
import com.android.core.domain.model.RequestData;
import com.android.gps.domain.VisitorLogDto;
import com.android.gps.domain.VisitorLogService;
import com.dto.LoginDto;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
@RequestMapping(value={"/android/visitor-log"})
public class VisitorLogController
extends AndroidController<VisitorLogDto> {
    protected VisitorLogController(Application app, AndroidService<VisitorLogDto> visitorLogService) {
        super(app, visitorLogService);
    }

    @ApiIgnore
    @GetMapping(value={"/customers-have-invoice"})
    public ResponseEntity<Map<String, Object>> getImage(HttpServletRequest request) {
        boolean isAndroid = ((LoginDto)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).isAndroid();
        if (!isAndroid) {
            return null;
        }
        RequestData requestData = RequestData.builder().paramMap(RequestData.normalizeServletParams((HttpServletRequest)request)).build();
        return ((VisitorLogService)this.service).getCustomerHasOrderAndInvoice(requestData);
    }

    @ApiIgnore
    @GetMapping(value={"/labels"})
    public ResponseEntity<Map<String, Object>> getLabels() {
        boolean isAndroid = ((LoginDto)SecurityContextHolder.getContext().getAuthentication().getPrincipal()).isAndroid();
        if (!isAndroid) {
            return null;
        }
        return ((VisitorLogService)this.service).getLabels();
    }
}

